<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('results', function (Blueprint $table) {
            $table->id();
            $table->string('student');
            $table->string('student_reg');
            $table->bigInteger('course_id');
            $table->string('session');
            $table->integer('year');
            $table->integer('semester');
            $table->integer('s_level');
            $table->integer('ca_score')->default(0);
            $table->string('grade')->nullable();
            $table->integer('exam_score')->default(0);
            $table->integer('total_score')->default(0);
            $table->bigInteger('admin_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('results');
    }
};
