<?php

use App\Http\Controllers\CourseFormController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaymentRrrController;
use App\Http\Controllers\TuitionController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\language\LanguageController;
use App\Http\Controllers\pages\MiscError;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


require __DIR__.'/auth.php';
require __DIR__.'/admin.php';

    // Main Page Route


// locale
    Route::get('lang/{locale}', [LanguageController::class, 'swap']);

// error page
    Route::get('/pages/misc-error', [MiscError::class, 'index'])->name('pages-misc-error');

   ############################## STUDENT MAIN ROUTES ############################################
    Route::middleware('auth:sanctum')->group(function () {
    Route::get('/student/dashboard', [HomeController::class, 'index'])->name('student-home');

    ############################## STUDENT FEES ROUTES ############################################
    Route::get('/student/list/tuition', [TuitionController::class, 'index'])->name('tuition');
    Route::post('/student/pay/tuition', [PaymentController::class, 'PayTuition'])->name('paytuition');
    Route::get('/student/list/rrr/{payid}', [PaymentRrrController::class, 'index'])->name('listrrr');
    Route::get('/verify/student/payment/{rrr}', [PaymentRrrController::class, 'verifyRrr'])->name('paymentverification');

  ############################## STUDENT COURSES ROUTES ############################################
    Route::get('load/student/course/form', [CourseFormController::class, 'index'])->name('load-course-form');
    Route::post('load/course/form', [CourseFormController::class, 'loadCourse'])->name('loadcourses');
    Route::get('print/student/course/form', [CourseFormController::class, 'listform'])->name('print-course');

    ############################## STUDENT RESULT ROUTES ############################################

      //Route::get('all/student/result', [\App\Http\Controllers\ResultController::class, 'index'])->name('viewResult');
      Route::match(['get', 'post'],'student/semester/result', [\App\Http\Controllers\ResultController::class, 'semesterResult'])->name('viewResult');






    });
