<?php

namespace App\Http\Controllers\Admin\Auth;


use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Password;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;

class ForgotPasswordController extends Controller
{
    use SendsPasswordResetEmails;

    /**
     * Only guests for "admin" guard are allowed except
     * for logout.
     *
     * @return void
     */

    public function __construct()
    {
        $this->middleware('guest:admin');
    }

    function sendResetLinkEmail(Request $request){
        $response = $this->broker('admins')->sendResetLink(['email' => $request->get('email')]);
        if ($response) {
          $pageConfigs = ['myLayout' => 'blank'];
          return view('admin.auth.auth-forgot-password', ['pageConfigs' => $pageConfigs])
            ->with('status', 'We have e-mailed your password reset link!');
    }
      $pageConfigs = ['myLayout' => 'blank'];
      return view('admin.auth.auth-forgot-password', ['pageConfigs' => $pageConfigs])
        ->with('status', 'Unable to e-mailed your password reset link!');
    }

    /**
     * Show the reset email form.
     *
     * @return \Illuminate\Http\Response
     */
    public function showLinkRequestForm(Request $request){
      $pageConfigs = ['myLayout' => 'blank'];
      return view('admin.auth.auth-forgot-password', ['pageConfigs' => $pageConfigs]);

    }

    /**
     * password broker for admin guard.
     *
     * @return \Illuminate\Contracts\Auth\PasswordBroker
     */
    public function broker(){
        return Password::broker('admins');
    }

    /**
     * Get the guard to be used during authentication
     * after password reset.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    public function guard(){
        return Auth::guard('admin');
    }
}
