<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Support\Facades\Hash;


class LoginController extends Controller{

    use ThrottlesLogins;

    public $maxAttempts = 33;

    /**
     * Number of minutes to lock the login.
     */
    public $decayMinutes = 30;



    public function username(){
        return 'email';
    }


    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('guest:admin')->except('logout');
    }





    /**
     * Show the login form.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function showLoginForm(): \Illuminate\Contracts\View\View
    {
      $pageConfigs = ['myLayout' => 'blank'];
      return view('admin.auth.auth-login-basic', ['pageConfigs' => $pageConfigs]);
    }


    /**
     * Login the admin.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function login(Request $request)
    {
        //Validation...

        //Login the admin...

        //Redirect the admin...
        // dd(Hash::make($request->password));

        $this->validator($request);

        if ($this->hasTooManyLoginAttempts($request)){
            //Fire the lockout event.
            $this->fireLockoutEvent($request);

            //redirect the user back after lockout.
            return $this->sendLockoutResponse($request);
        }

        // dd(Hash::make($request['password']));

        $data = Admin::Query()->where('email',$request->email)->first();
        if($data->status!=1){
            return back()
            ->withInput()
            ->withError("Your access has been revoked as your account is suspended or banned");
        }

        if(Auth::guard('admin')->attempt($request->only('email','password'),$request->filled('remember'))){
            //Authentication passed...
            //if($request->input('oldnew')==1){$request->session()->put('period', 'old');}
            return redirect()
                ->intended(route('admin.home'))
                ->with('status','You are Logged in as Admin!');
        }

        $this->incrementLoginAttempts($request); $this->incrementLoginAttempts($request);

        //Authentication failed...
         return back()->withInput($request->only('email', 'remember'))->with('error','Login failed, please try again!');
    }

    /**
     * Logout the admin.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function logout()
    {
        //logout the admin...
        Auth::guard('admin')->logout();
        return redirect()
            ->route('admin.login')
            ->with('status','Admin has been logged out!');
    }

    /**
     * Validate the form data.
     *
     * @param \Illuminate\Http\Request $request
     * @return
     */
    private function validator(Request $request)
    {
        //validate the form...
        //validation rules.
        $rules = [
            'email'    => 'required|email|exists:admins|min:5|max:191',
            'password' => 'required|string|min:4|max:255',
        ];

        //custom validation error messages.
        $messages = [
            'email.exists' => 'These credentials do not match our records.',
        ];

        //validate the request.
        $request->validate($rules,$messages);
    }

    /**
     * Redirect back after a failed login.
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    private function loginFailed()
    {
        //Login failed...
        return redirect()
            ->back()
            ->withInput()
            ->with('error','Login failed, please try again!');
    }
}
