<?php

namespace App\Http\Controllers;

use App\Models\CourseForm;
use App\Http\Requests\StoreCourseFormRequest;
use App\Http\Requests\UpdateCourseFormRequest;
use App\Models\Courses;
use App\Models\DepartmentCourseSettings;
use App\Models\LoadedCourses;
use App\Models\Period;
use App\Models\Semester;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class CourseFormController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($cusid='')
    {
      if ($cusid != '') {
        $check=CourseForm::find($cusid);
        if ($check==null) {
          return back()->with('error', 'CourseForm not found');
        }
        if($check->printed_on != null){
          return redirect()->route('course.printed',$check->id)->with('error', 'You have printed this Course Form. To add or drop any course go to the ICT unit with you original printout and a photocopy.');;

        }
        $semester = Semester::find($check->semester);
        $period = Period::where('c_session', $check->session)->first();
        $user = auth()->user();
        $stdlvl=$check->student_level;
        $deptSettings=DepartmentCourseSettings::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->first();
        $course = Courses::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->get();
        return view('courses.load_course_form', compact('course','deptSettings','user','semester','period','stdlvl'));


      }
      $semester = Semester::where('status', 1)->first();
      $period = Period::where('status', 1)->first();
      $user = auth()->user();
      $deptSettings=DepartmentCourseSettings::where(['department_id'=>$user->department_id,'level'=>$user->s_level,'semester'=>$semester->id])->first();

      $check=CourseForm::where(['student_id'=>$user->id, 'session'=>$period->c_sesson, 'semester'=>$semester->id]);
      if ($check->exists()) {

        if($check->first()->printed_on != null){
          return redirect()->route('course.printed',$check->id)->with('error', 'You have printed this Course Form. To add or drop any course go to the ICT unit with you original printout and a photocopy.');;

        }
      }
      $course = Courses::where(['department_id'=>$user->department_id,'level'=>$user->s_level,'semester'=>$semester->id])->get();
      return view('courses.load_course_form', compact('course','deptSettings','user','semester','period'));
    }


    function carryover($course_form_id)
    {
      $check=CourseForm::find($course_form_id);
      if ($check==null) {
        return back()->with('error', 'Course Form not found');
      }
      if($check->printed_on != null){
        return redirect()->route('course.printed',$course_form_id)
          ->with('error', 'You have printed this Course Form. To add or drop any course go to the ICT unit with you original printout and a photocopy.');;
      }
      $semester = Semester::find($check->semester);
      $period = Period::where('c_session', $check->session)->first();
      $user = auth()->user();
      $stdlvl=$check->student_level;
      $deptSettings=DepartmentCourseSettings::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->first();
      $course = Courses::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->get();
      $course2 = Courses::where(['department_id'=>$user->department_id,'semester'=>$semester->id])->where('level','<',$stdlvl)->get();
      return view('courses.add_carry_over', compact('course','deptSettings','user','semester','period','stdlvl','course2'));

    }




  public function oldform(Request $request)
  {
    if ($request->isMethod('get')) {
      $semeste = Semester::all();
      $period = Period::all();
      return view('courses.old_course_form', compact('semeste','period'));
    }else{
      $request->validate([
        'sess' => ['required'],
        'sem' => ['required'],
        'lvl' => ['required'],
      ]);

      if ($request->lvl >$request->user()->s_level) {
        return back()->with('error', 'You can\'t load courses for a level you have not attained');
      }
      if ($request->lvl == $request->user()->s_level) {
        return back()->with('error', 'You are loading courses for your current level please click on COURSE FORM on the menu');
      }
      $semester = Semester::find($request->sem);
      $period = Period::where('c_session', $request->sess)->orWhere('c_year', $request->sess)->first();
      $user = auth()->user();
      $stdlvl=$request->lvl;
      $deptSettings=DepartmentCourseSettings::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->first();
      $check=CourseForm::where(['student_id'=>$user->id, 'session'=>$period->c_sesson, 'semester'=>$semester->id]);

      if ($check->exists()) {

        if($check->first()->printed_on != null){
          return redirect()->route('course.printed',$check->id)->with('error', 'You have printed this Course Form. To add or drop any course go to the ICT unit with you original printout and a photocopy.');;

        }
      }

      $course = Courses::where(['department_id'=>$user->department_id,'level'=>$stdlvl,'semester'=>$semester->id])->get();

      return view('courses.load_course_form', compact('course','deptSettings','user','semester','period','stdlvl'));

    }
   }




    /**
     * Show the form for creating a new resource.
     */
    public function listform($cid)
    {
        //
      $cusfom=CourseForm::with(['loadedcourses.course'])->find($cid);
      if ($cusfom==null) {
        return back()->with('error', 'CourseForm not found');
      }
      return view('courses.listform', compact('cid', 'cusfom'));
    }

  public function listdoneform(Request $request)
  {
    //
    $cusfom=CourseForm::where("student_id",$request->user()->id)->get();

    return view('courses.list_course_forms', compact( 'cusfom'));
  }


    static function splitcus($cus)
    {
      return explode('/', $cus);
    }

  function cusprint($cid)
  {
    $cusfom=CourseForm::with(['loadedcourses.course'])->find($cid);
    if ($cusfom->printed_on ==null) {
    $cusfom->printed_on=NOW();
    $cusfom->save();
    }
    $user=User::with(['department','program','faculty'])->find($cusfom->student_id);

    $image = base64_encode(QrCode::format('png')
      ->merge(asset('assets/img/pages/login-light.png'), 0.5, true)
      ->size(300)
      ->errorCorrection('H')
      ->generate(route('verify.course',$cusfom->form_code)));

    return view('courses.course_form_print', compact( 'cusfom','user','image'));
  }



    function loadCourse(Request $request)
    {

      $validator = Validator::make($request->all(), [
        'cuss' => 'required|array|min:1', // 'items' must be an array with at least one element
      ]);
      if ($validator->fails()) {
        return back()->with('error',$validator->errors());
      }
      $check=CourseForm::where(['student_id'=>$request->usid, 'session'=>$request->peri, 'semester'=>$request->semes]);
      if ($check->exists()) {
          $tr=$check->first();
          LoadedCourses::where('course_form_id',$tr->id)->delete();
          //$lcus= new LoadedCourses;
        foreach ($request->cuss as $course){
          $lcus= new LoadedCourses;
          $cusSplit = explode('/', $course);
          $lcus->course_form_id=$tr->id;
          $lcus->student_id=$request->usid;
          $lcus->course_id=$cusSplit[0];
          $lcus->course_load=$cusSplit[1];
          $lcus->save();
        }
        return redirect()->route('course.printed',$tr->id);

      }else{
        $cf=new CourseForm;
        $cf->student_id=$request->usid;
        $cf->session=$request->peri;
        $cf->semester=$request->semes;
        $cf->student_level=$request->slvl;
        $cf->pc_ip=$request->ip();
        $cf->form_code=Str::uuid7()->toString();
        $cf->save();

      foreach ($request->cuss as $course){
        $lcus= new LoadedCourses;
        $cusSplit = explode('/', $course);
        $lcus->course_form_id=$cf->id;
        $lcus->student_id=$request->usid;
        $lcus->course_id=$cusSplit[0];
        $lcus->course_load=$cusSplit[1];
        $lcus->save();
      }
      return redirect()->route('course.printed',$cf->id);

      }

    }

 function verifycus($cid)
 {
   $cusfom=CourseForm::with(['loadedcourses'=>['course','student']])->find($cid);
   if ($cusfom==null) {
    print ("Course Form not Valid");
   }else{

     $msg=$cusfom->session.' course form belonging to: '.$cusfom->student->surname.' '.$cusfom->student->othernames;
      print $msg;
 }
 }





}
