<?php

namespace App\Http\Controllers;

use App\Imports\ResultsImport;
use App\Models\CourseForm;
use App\Models\Courses;
use App\Models\DummyResult;
use App\Models\Period;
use App\Models\Result;
use App\Http\Requests\StoreResultRequest;
use App\Http\Requests\UpdateResultRequest;
use App\Models\Semester;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class ResultController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {

      $results = Result::where(['student'=>Auth::user()->email])->with('resultcourse')->get();
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function semesterResult(Request $request)
    {
      $allperiods = Period::all();
      $allsemesters = Semester::all();
      if ($request->isMethod('post')) {
        $semester = Semester::find($request->sem);
        $period = Period::where('c_year', $request->sess)->first();
      }else{
        $semester = Semester::where('status', 1)->first();
        $period = Period::where('status', 1)->first();
      }
      $cusfom=CourseForm::with(['loadedcourses.course'])->where(['student_id'=>$request->user()->id, 'session'=>$period->c_session, 'semester'=>$semester->id])->first();

      $user=Auth::user();
//      $result=Result::where(["student_reg"=>\auth()->user()->reg_number,"semester"=>$semester->id,"year"=>$period->c_year])->with('resultcourse')->get();
      return view('results.student_result', compact('cusfom','semester','period','allperiods','allsemesters','user'));
    }

    function resultprint($cid)
    {
      $cusfom=CourseForm::with(['loadedcourses.course'])->find($cid);

      $user=User::with(['department','program','faculty'])->find($cusfom->student_id);

      $image = base64_encode(QrCode::format('png')
        ->merge(asset('assets/img/pages/login-light.png'), 0.5, true)
        ->size(300)
        ->errorCorrection('H')
        ->generate(route('verify.course',$cusfom->form_code)));

      return view('results.result_print', compact( 'cusfom','user','image'));
    }




  function uploadResult(Request $request)
  {
    if ($request->isMethod('get')) {
      $periods = Period::all();
      $semesters = Semester::all();
      $course=Courses::all();
      return view('admin.result.upload-result', compact('periods','semesters','course'));
    }else{

      $request->validate([
        'result' => 'required|file|mimes:csv,xlsx'

      ]);
      $sess=$request->year.'/'.$request->year+1;
      try {
        $admin=Auth::guard('admin')->user()->id;
        DB::statement("TRUNCATE TABLE dummy_results");
        Excel::import(new ResultsImport($request->sem,$request->course,$request->year,$sess,$admin), $request->file('result'));
        $gh=DB::statement("UPDATE `dummy_results` a, users b SET a.student_id=b.id WHERE a.student_reg=b.reg_number AND a.student_id is NULL; ");

        $result=DummyResult::with(['dummyresultcourse','dummyresultadmin'])->get();
        return view('admin.result.verify-upload', compact('result'));
        //return back()->with('success', 'Result imported successfully!');
      }catch (\Exception $exception){
        //dd($exception->failures());
        return back()->with('error', $exception->getMessage());
      }


    }
  }
}
