<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\PasswordResetByAdmin;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Password;

class PasswordController extends Controller
{
    /**
     * Update the user's password.
     */
    public function update(Request $request): RedirectResponse
    {
        $validated = $request->validateWithBag('updatePassword', [
            'current_password' => ['required', 'current_password'],
            'password' => ['required', Password::defaults(), 'confirmed'],
        ]);

        $request->user()->update([
            'password' => Hash::make($validated['password']),
        ]);

        return back()->with('status', 'password-updated');
    }
    function resetStudentPassword(Request $request)
    {
      if ($request->isMethod('get')) {
        return view('admin.student.resetpassword');
      }else{
        $request->validate([
          'email' => ['required', 'email','exists:users,email'],
        ]);
        $user=User::where('email',$request->email)->first();
        $password=Str::random(10);
        $user->forceFill([

          'password' => Hash::make($password)

        ])->setRememberToken(Str::random(60));

        $user->save();

        $user->notify(new PasswordResetByAdmin($password));
        return back()->with('status', 'Student password reset successfully. An email containing the password has been sent to the student');
      }


    }
}
