<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
      'email', 'phone', 'reg_number', 'jamb_number', 'surname', 'other_names', 'email_verified_at', 'password', 'prog_id', 'faculty_id', 'department_id', 's_level', 'gender', 'dob', 'marital_status', 'nationality', 'state', 'lga', 'home_town', 'address', 'place_of_birth', 'parent_title', 'parent_name', 'parent_phone', 'parent_email', 'next_of_kin_name', 'next_of_kin_phone', 'next_of_kin_email', 'next_of_kin_relationship', 'next_of_kin_address', 'primary_school', 'primary_school_start', 'primary_school_end', 'secondary_school', 'secondary_school_start', 'secondary_school_end', 'secondary_school_Certificate', 'tertiary_school', 'tertiary_school_start', 'tertiary_school_end', 'tertiary_school_Certificate', 'tertiary_course_1', 'tertiary_course_1_grade', 'tertiary_course_2', 'tertiary_course_2_grade', 'tertiary_course_3', 'tertiary_course_3_grade', 'tertiary_course_4', 'tertiary_course_4_grade', 'avatar', 'status', 'transferred_by', 'entry_type', 'entry_year', 'entry_session', 'campus'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    function department()
    {
      return $this->belongsTo(Department::class);
    }

    function faculty()
    {
      return $this->belongsTo(Faculty::class);
    }

    function program()
    {
      return $this->belongsTo(Program::class, 'prog_id');
    }
}
