<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class Adminpasswordrecovery extends Notification
{
  use Queueable;

  /**
   * Create a new notification instance.
   *
   * @return void
   */
  private $token;
  public function __construct($token)
  {
    //
    $this->token=$token;
  }

  /**
   * Get the notification's delivery channels.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function via(mixed $notifiable)
  {
    return ['mail'];
  }

  /**
   * Get the mail representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return \Illuminate\Notifications\Messages\MailMessage
   */
  public function toMail(mixed $notifiable): MailMessage
  {
    $link = url( "/admin/password/reset/" . $this->token );
    return ( new MailMessage )

      ->subject( ' Password Reset Link')
      ->greeting('Hello!')
      ->line( "You are receiving this email because we received a password reset request for your account. " )
      ->action( 'Reset Password', $link )
      ->line( 'Thank you!' );

  }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
