<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PasswordResetByAdmin extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
  private $password;
  public function __construct($password)
  {
    //
    $this->password=$password;
  }

  /**
   * Get the notification's delivery channels.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function via(mixed $notifiable)
  {
    return ['mail'];
  }

  /**
   * Get the mail representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return \Illuminate\Notifications\Messages\MailMessage
   */
  public function toMail(mixed $notifiable): MailMessage
  {

    return ( new MailMessage )

      ->subject( 'Your password Was Reset By an Admin')
      ->greeting('Hello!')
      ->line( "You are receiving this email because we received a password reset request for your account. " )
      ->line( 'Your New Password is '. $this->password )
      ->line( 'Thank you!' );

  }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
