<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
  /**
   * Register services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap services.
   */
  public function boot(): void
  {
    $verticalMenuJson = file_get_contents(base_path('resources/menu/verticalMenu.json'));
    $verticalMenuData = json_decode($verticalMenuJson);
    $horizontalMenuJson = file_get_contents(base_path('resources/menu/horizontalMenu.json'));
    $horizontalMenuData = json_decode($horizontalMenuJson);

    $verticalMenuJsonAdmin = file_get_contents(base_path('resources/menu/verticalMenuAdmin.json'));
    $verticalMenuDataAdmin = json_decode($verticalMenuJsonAdmin);
    $horizontalMenuJsonAdmin = file_get_contents(base_path('resources/menu/horizontalMenuAdmin.json'));
    $horizontalMenuDataAdmin = json_decode($horizontalMenuJsonAdmin);

    // Share all menuData to all the views
    \View::share('menuData', [$verticalMenuData, $horizontalMenuData]);
    \View::share('menuDataAdmin', [$verticalMenuDataAdmin, $horizontalMenuDataAdmin]);
  }
}
