<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('applicants', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique();
            $table->string('phone')->unique();
            $table->string('jamb_number')->unique();
            $table->integer('jamb_score')->default(0);
            $table->string('surname');
            $table->string('other_names');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->bigInteger('prog_id');
            $table->integer('faculty_id');
            $table->integer('department_id');
            $table->integer('s_level')->default(1);
            $table->string('gender');
            $table->string('dob');
            $table->string('marital_status')->default('Single');
            $table->string('nationality')->default('Nigeria');
            $table->integer('state');
            $table->integer('lga');
            $table->string('home_town');
            $table->string('address');
            $table->string('place_of_birth');
            $table->string('parent_title')->nullable();
            $table->string('parent_name')->nullable();
            $table->string('parent_phone')->nullable();
            $table->string('parent_email')->nullable();
            $table->string('next_of_kin_name')->nullable();
            $table->string('next_of_kin_phone')->nullable();
            $table->string('next_of_kin_email')->nullable();
            $table->string('next_of_kin_relationship')->nullable();
            $table->string('next_of_kin_address')->nullable();
            $table->string('primary_school')->nullable();
            $table->string('primary_school_start')->nullable();
            $table->string('primary_school_end')->nullable();
            $table->string('secondary_school')->nullable();
            $table->string('secondary_school_start')->nullable();
            $table->string('secondary_school_end')->nullable();
            $table->string('secondary_school_Certificate')->nullable();
            $table->string('tertiary_school')->nullable();
            $table->string('tertiary_school_start')->nullable();
            $table->string('tertiary_school_end')->nullable();
            $table->string('tertiary_school_Certificate')->nullable();
            $table->string('tertiary_course_1')->nullable();
            $table->string('tertiary_course_1_grade')->nullable();
            $table->string('tertiary_course_2')->nullable();
            $table->string('tertiary_course_2_grade')->nullable();
            $table->string('tertiary_course_3')->nullable();
            $table->string('tertiary_course_3_grade')->nullable();
            $table->string('tertiary_course_4')->nullable();
            $table->string('tertiary_course_4_grade')->nullable();
            $table->string('avatar')->default('default.png');
            $table->integer('status')->default(1);
            $table->integer('entry_type')->default(1);
            $table->string('entry_year');
            $table->string('entry_session');
            $table->string('campus')->default('Main Campus Nsugbe');
            $table->integer('stage')->default(1);
            $table->integer('screened')->default(0);
            $table->string('screened_by')->nullable();
            $table->integer('cleared')->default(0);
            $table->string('cleared_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('applicants');
    }
};
