<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('departments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('program_id')->unsigned();
            $table->bigInteger('faculty_id')->unsigned();
            $table->string('name');
            $table->string('slug');
            $table->string('code');
            $table->integer('levels')->default(4);
            $table->bigInteger('hod')->nullable();
            $table->string('description')->nullable();
            $table->string('department_email')->nullable();
            $table->string('department_phone')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('departments');
    }
};
