<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fees', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('program_id');
            $table->unsignedBigInteger('department_id');
            $table->integer('level')->default(0);
            $table->double('full_amount')->default(0);
            $table->double('first_semester_amount')->default(0);
            $table->double('second_semester_amount')->default(0);
            $table->string('bank');
            $table->string('bank_code');
            $table->string('account_number');
            $table->string('service_type_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fees');
    }
};
