<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loaded_courses', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('course_form_id')->unsigned();
            $table->foreign('course_form_id')->references('id')->on('course_forms');
            $table->bigInteger('student_id')->unsigned();
            $table->foreign('student_id')->references('id')->on('users');
            $table->bigInteger('course_id')->unsigned();
            $table->foreign('course_id')->references('id')->on('courses');
            $table->integer('course_load')->nullable();
            $table->integer('carry_over')->default(0);
            $table->bigInteger('admin_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loaded_courses');
    }
};
