<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('department_course_settings', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('department_id');
            $table->integer('level');
            $table->integer('semester');
            $table->integer('min_unit_load')->default(0);
            $table->integer('max_unit_load')->default(20);
            $table->integer('lock_course_form')->default(0);
            $table->bigInteger('admin_id')->unsigned()->nullable();
            $table->foreign('admin_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('department_course_settings');
    }
};
