<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hostel_rooms', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('hostel_id')->unsigned();
            $table->foreign('hostel_id')->references('id')->on('hostels')->onDelete('cascade');
            $table->bigInteger('hostel_floor_id')->unsigned();
            $table->foreign('hostel_floor_id')->references('id')->on('hostel_floors')->onDelete('cascade');
            $table->string('room_name');
            $table->integer('number_of_bedspace');
            $table->integer('available_bedspace')->default(0);
            $table->enum('ensuite',['Yes','No'])->default('No');
            $table->enum('status',['Available','Occupied','maintenance'])->default('Available');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hostel_rooms');
    }
};
