<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bed_spaces', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('hostel_id')->unsigned();
            $table->foreign('hostel_id')->references('id')->on('hostels');
            $table->bigInteger('hostel_floor_id')->unsigned();
            $table->foreign('hostel_floor_id')->references('id')->on('hostel_floors');
            $table->bigInteger('hostel_room_id')->unsigned();
            $table->foreign('hostel_room_id')->references('id')->on('hostel_rooms');
            $table->enum('bed_type',['Single','Double'])->default('Double');
            $table->enum('position',['up','down'])->default('down');
            $table->double('price',10,2)->default(0);
            $table->enum('status',['Available','Occupied','maintenance'])->default('Available');
            $table->bigInteger('occupied_by')->unsigned();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bed_spaces');
    }
};
