@extends('admin/layouts/layoutMaster')

@section('title', 'Result Upload')

@section('vendor-style')
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/dropzone/dropzone.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/select2/select2.css')}}" />
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/bootstrap-select/bootstrap-select.css')}}" />
@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/dropzone/dropzone.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/select2/select2.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/bootstrap-select/bootstrap-select.js')}}"></script>

@endsection

@section('page-script')
  <script src="{{asset('assets/js/forms-selects.js')}}"></script>
  <script src="{{asset('assets/js/forms-file-upload.js')}}"></script>
@endsection

@section('content')


  <div class="row">
    <!-- Basic  -->
    <div class="col-12">
      <div class="card mb-4">
        <h5 class="card-header">Result Upload</h5>
        @if(session()->has('errors'))
          <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
            {{session('errors')->first() }}

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            </button>
          </div>
        @endif
        @if(session()->has('error'))
          <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
            {{session()->get('error')}}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
            </button>
          </div>
        @endif
        <div class="card-body">
          <form action="{{route('admin.uploadresult')}}" method="post" enctype="multipart/form-data">
            @csrf

            <div class="row g-2">

              <div class="col-md-6 ">
                <label class="form-label" for="multicol-course">Course</label>
                <select id="multicol-course" name="course" class="select2 form-select form-select-lg" data-allow-clear="true">
                  @foreach($course as $c)
                    <option value="{{$c->id}}">[{{$c->code}}]  {{$c->name}}</option>
                  @endforeach
                </select>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">Select Session</label>

                <select  class="select2 form-select"  data-allow-clear="true" name="year">
                  @foreach($periods as $p)
                    <option value="{{$p->c_year}}">{{$p->c_session}}</option>
                  @endforeach
                </select>
              </div>
              <div class="col-md-6">
                <label class="form-label" for="basic-default-fullname">Select Semester</label>
                <select  class="select2 form-select" data-allow-clear="true" name="sem">
                  @foreach($semesters as $pp)
                    <option value="{{$pp->id}}">{{$pp->name}}</option>
                  @endforeach
                </select>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="resultfile">Result File</label>
                <input class="form-control" name="result" type="file" accept=".csv,.xlsx" />
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">.</label>
                <button type="submit" class="btn btn-primary">Upload Result</button>
              </div>
              <div class="col-md-6 ">
                <label class="form-label" for="basic-default-fullname">.</label>
                <a href="{{url('admin/download/result/template')}}"> <button type="button" class="btn btn-success">Download Template</button></a>
              </div>

            </div>

          </form>
        </div>
      </div>
    </div>
    <!-- /Basic  -->

  </div>
@endsection
