@php
  $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Admin Password Confirm')

@section('vendor-style')
  <!-- Vendor -->
  <link rel="stylesheet" href="{{asset('assets/vendor/libs/@form-validation/umd/styles/index.min.css')}}" />
@endsection

@section('page-style')
  <!-- Page -->
  <link rel="stylesheet" href="{{asset('assets/vendor/css/pages/page-auth.css')}}">
@endsection

@section('vendor-script')
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/bundle/popular.min.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/plugin-bootstrap5/index.min.js')}}"></script>
  <script src="{{asset('assets/vendor/libs/@form-validation/umd/plugin-auto-focus/index.min.js')}}"></script>
@endsection

@section('page-script')
  <script src="{{asset('assets/js/pages-auth.js')}}"></script>
@endsection

@section('content')
  <div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
      <div class="authentication-inner py-4">

        <!-- Register -->
        <div class="card">
          <div class="card-body">


            <p class="mb-4">Please Enter Students Email</p>
            @if(session()->has('errors'))
              <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
                {{session('errors')->first() }}

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            @endif
            @if(session()->has('status'))
              <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
                {{session()->get('status')}}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            @endif
            <form id="formAuthentication" class="mb-3" action="{{route('admin.reset-password')}}" method="post">
              @csrf

              <div class="mb-3 form-password-toggle">
                <div class="d-flex justify-content-between">
                  <label class="form-label" for="email">Email</label>
                </div>
                <div class="input-group input-group-merge">
                  <input type="email" id="email" class="form-control" name="email" placeholder="johndoe@email.com" aria-describedby="email" />

                </div>
              </div>

              <button class="btn btn-primary d-grid w-100">
                Reset Password
              </button>
            </form>



          </div>
        </div>
        <!-- /Register -->
      </div>
    </div>
  </div>
@endsection
