@extends('layouts/layoutMaster')

@section('title', 'Old Course Form')

@section('vendor-style')

  <link href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-2.3.4/b-3.2.5/b-html5-3.2.5/b-print-3.2.5/cr-2.1.1/cc-1.1.0/date-1.6.0/fc-5.0.5/fh-4.0.4/kt-2.12.1/r-3.0.7/rg-1.6.0/rr-1.5.0/sc-2.4.3/sb-1.8.4/sp-2.3.5/sl-3.1.2/datatables.min.css" rel="stylesheet" integrity="sha384-sJUMfrejiv5pRmY5qNGZVl4JMtWiZ53QA1/6/7GLLBQdxCJMhOwunSFrcJT3Xlkk" crossorigin="anonymous">

@endsection



@section('content')
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Old /</span>course form
  </h4>
  <div class="accordion mb-4" id="collapsibleSection">
    <div class="card accordion-item">
      <h2 class="accordion-header" id="headingDeliveryAddress">
        <button type="button" class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseDeliveryAddress" aria-expanded="true" aria-controls="collapseDeliveryAddress">
         Set Details </button>
      </h2>
      <div id="collapseDeliveryAddress" class="accordion-collapse collapse show" data-bs-parent="#collapsibleSection">
        <div class="accordion-body">
          <div class="row g-3">
            <div class="card ">

              <div class="card-body">
                @if(session()->has('errors'))
                  <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
                    {{session('errors')->first() }}

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    </button>
                  </div>
                @endif
                  @if(session()->has('error'))
                    <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
                      {{session()->get('error')}}
                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      </button>
                    </div>
                  @endif
                <form class="w-px-500 border rounded p-3 p-md-8" method="post" action="{{route('old-course-form')}}">
                  @csrf
                  <div class="mb-3">
                    <label class="form-label" for="basic-default-fullname">Select Session</label>

                    <select  class="select2 form-select" data-allow-clear="true" name="sess">
                      @foreach($period as $p)
                        <option value="{{$p->c_year}}">{{$p->c_session}}</option>
                      @endforeach
                    </select>
                  </div>
                  <div class="mb-3">

                    <label class="form-label" for="basic-default-fullname">Select Semester</label>
                    <select  class="select2 form-select" data-allow-clear="true" name="sem">

                      @foreach($semeste as $pp)
                        <option value="{{$pp->id}}">{{$pp->name}}</option>
                      @endforeach
                    </select>
                  </div>

                  <div class="mb-3">
                    <label class="form-label" for="basic-default-fullname">Select Level</label>
                    <select  class="select2 form-select" data-allow-clear="true" name="lvl">

                      <option value="1">100 Level</option>
                      <option value="2">200 Level</option>
                      <option value="3">300 Level</option>
                      <option value="4">400 Level</option>

                    </select>
                  </div>

                  <button type="submit" class="btn btn-primary">Load Form</button>
                </form>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>






@endsection

