<?php $__env->startSection('title', 'Preview - Course Form'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/app-invoice.css')); ?>" />
<?php $__env->stopSection(); ?>



<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/moment/moment.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/flatpickr/flatpickr.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/cleavejs/cleave.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

  <div class="row invoice-preview">
    <!-- Invoice -->
    <div class="col-xl-9 col-md-8 col-12 mb-md-0 mb-4">
      <div class="card invoice-preview-card">
        <div class="card-header">
          <?php if(session()->has('error')): ?>
            <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
              <?php echo e(session()->get('error')); ?>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          <?php endif; ?>
        </div>
        <div class="card-body">
          <div class="row p-sm-3 p-0">

            <div class="col-xl-12 col-md-12 col-sm-12 col-12">
              <h6 class="pb-2">Course registration summary:</h6>
              <table>
                <tbody>
                <tr>
                  <td class="pe-3">Number Of Courses:</td>
                  <td class="fw-medium"><?php echo e(count($cusfom->loadedcourses)); ?></td>
                </tr>
                <tr>
                  <td class="pe-3">Session:</td>
                  <td><?php echo e($cusfom->session); ?></td>
                </tr>
                <tr>
                  <td class="pe-3">Semester:</td>
                  <td><?php if($cusfom->semester==1): ?> First Semester <?php else: ?> Second Semester <?php endif; ?></td>
                </tr>
                <tr>
                  <td class="pe-3">Level:</td>
                  <td><?php echo e($cusfom->student_level); ?>00 Level</td>
                </tr>
                <tr>
                  <td class="pe-3">Total Credit Unit:</td>
                  <td><?php echo e($cusfom->loadedcourses->sum('course_load')); ?></td>
                </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="table-responsive">
          <table class="table border-top m-0">
            <thead>
            <tr>
              <th>S/n</th>
              <th>Course Code</th>
              <th>Course Name</th>
              <th>Credit Unit</th>

            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $cusfom->loadedcourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td ><?php echo e($loop->iteration); ?></td>
              <td><?php echo e($cs->course->code); ?></td>
              <td class="text-nowrap"><?php echo e($cs->course->name); ?></td>
              <td><?php echo e($cs->course->credit_unit); ?></td>

            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>

        <div class="card-body">
          <div class="row">
            <div class="col-12">
              <span class="fw-medium">Note:</span>
              <span>Please verify your courses before you print. Once you print it you will not be able to edit it on your own again . Thank You!</span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- /Invoice -->

    <!-- Invoice Actions -->
    <div class="col-xl-3 col-md-4 col-12 invoice-actions">
      <div class="card">

        <div class="card-body">




          <a class="btn btn-label-danger d-grid w-100 mb-3" target="_blank" href="<?php echo e(route('course.form.print',$cid)); ?>">
            Print
          </a>
          <a href="<?php echo e(route("load-course-form",$cid)); ?>" class="btn btn-label-primary d-grid w-100 mb-3">
            Edit Course Form
          </a>
          <a href="<?php echo e(route("load-carry-over",$cid)); ?>" class="btn btn-label-success d-grid w-100 mb-3">
            Add Carry Over
          </a>

        </div>
      </div>
    </div>
    <!-- /Invoice Actions -->
  </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/courses/listform.blade.php ENDPATH**/ ?>