<?php
  use App\Models\Fee;use App\Models\Payment;$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Tuition'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/moment/moment.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>

  <script>
    $('#modalCenter').on('show.bs.modal',  function (event) {

      var button = $(event.relatedTarget); // Button that triggered the modal
      var lvl = button.data('level'); // Extract info from data-* attributes
      var yer = button.data('year');
      var sem = button.data('sem');
      var nsem = button.data('nsem');
      var famt = button.data('famount');
      var hamt = button.data('halfamt');
      var modal = $(this);
      modal.find('.modal-title').text('Pay Tuition for ' + lvl +"00 Level");
      modal.find('.modal-body input#paylvl').val(lvl);
      modal.find('.modal-body input#payyear').val(yer);
      modal.find('.modal-body input#paysem').val(sem);
      // modal.find('.modal-body input#semest').val(famt);
      modal.find('.modal-body #amt').text("₦ "+famt);
      modal.find('.modal-body #wsem').text("Part Payment ("+nsem+")");
      // modal.find('.modal-body input#semest2').val(hamt);
      modal.find('.modal-body #amt2').text("₦ "+hamt);

    });

    $("input:checkbox").on('click', function() {
      // in the handler, 'this' refers to the box clicked on
      var $box = $(this);
      if ($box.is(":checked")) {
        // the name of the box is retrieved using the .attr() method
        // as it is assumed and expected to be immutable
        var group = "input:checkbox[name='" + $box.attr("name") + "']";
        // the checked state of the group/box on the other hand will change
        // and the current value is retrieved using .prop() method
        $(group).prop("checked", false);
        $box.prop("checked", true);
      } else {
        $box.prop("checked", false);
      }
    });
  </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <h4 class="py-3 breadcrumb-wrapper mb-4">
    <span class="text-muted fw-light">Student /</span> Fees
  </h4>

<?php $__errorArgs = ['msg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
  <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
    <i class="bx bx-xs bx-detail me-2"></i>
    <?php echo e($message); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
    </button>
  </div>

<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

  <!-- Bootstrap Table with Header - Dark -->
  <div class="card">
    
    <div class="table-responsive text-nowrap">
      <table class="table">
        <thead class="table-dark">
        <tr>
          <th>Session</th>
          <th>Year</th>
          <th>Level</th>
          <th>Amount Payable</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">
        <?php $__currentLoopData = $feehist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><span class="fw-medium"><?php echo e($f->c_session); ?></span></td>
            <td>
              <?php echo e($f->c_year); ?>

            </td>
            <td>
              <?php echo e($loop->iteration); ?>

            </td>
            <td>&#8358; <?php echo e(Fee::getFee($user->department_id,$loop->iteration)->full_amount); ?></td>
            <?php
            $fee=Fee::getFee($user->department_id,$loop->iteration);
              $check=Payment::checkTuition($user->email,$f->c_year);
              if($check['pay'] == 1){
            ?>
              <td><span class="badge bg-label-primary me-1"><?php echo e($check['paydit']->status); ?></span></td>
              <td>
             <a class="btn btn-primary w-55 my-3" href="<?php echo e(route("listrrr",$check['paydit']->id)); ?>"  style="color: white">View Payment</a>

              </td>
<?php
              }else{
?>
                 <td><span class="badge bg-label-primary me-1">NO RRR Yet</span></td>
              <td>
                <a class="btn btn-warning w-55 my-3 paytuit" data-bs-toggle="modal" style="color: white"
                   data-bs-target="#modalCenter" data-level="<?php echo e($loop->iteration); ?>" data-session="<?php echo e($f->c_session); ?>"
                   data-year="<?php echo e($f->c_year); ?>" data-sem="<?php echo e($current_semester->id); ?>" data-famount="<?php echo e($fee->full_amount); ?>" <?php if($current_semester->id==1): ?> data-halfamt="<?php echo e($fee->first_semester_amount); ?>"
                   <?php else: ?> data-halfamt="<?php echo e($fee->second_semester_amount); ?>" <?php endif; ?> data-nsem="<?php echo e($current_semester->name); ?>">
                  Pay Tuition
                </a>
              </td>
            <?php
              }
            ?>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
  <!--/ Bootstrap Table with Header Dark -->

  <div class="modal fade" id="modalCenter" tabindex="-1" aria-hidden="true">
    <form method="post" action="<?php echo e(route('paytuition')); ?>" >
      <?php echo csrf_field(); ?>
    <div class="modal-dialog modal-dialog-centered" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modalCenterTitle">Pay Tuition</h5>
          <button
            type="button"
            class="btn-close"
            data-bs-dismiss="modal"
            aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="plevel" id="paylvl" value="">
          <input type="hidden" name="pyear" id="payyear" value="">
          <input type="hidden" name="psem" id="paysem" value="">
          <table class="table">

            <tbody class="table-border-bottom-0">
            <tr>
              <td>
                <div class="form-check mt-3">
                  <input class="form-check-input" checked type="checkbox" name="popt" value="0" id="semest" />

                </div>
              </td>
              <td>Full Payment</td>
              <td id="amt"></td>
            </tr>

            <tr>
              <td>
                <div class="form-check mt-3">
                  <input class="form-check-input" type="checkbox" name="popt" value="<?php echo e($current_semester->id); ?>" id="semest2" />
                </div>
              </td>
              <td id="wsem">Part Payment</td>
              <td id="amt2"></td>
            </tr>

            </tbody>

          </table>

        </div>
        <div class="modal-footer">

          <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
            Close
          </button>
          <button type="submit" class="btn btn-primary">Get RRR</button>
        </div>
      </div>
    </div>

    </form>
  </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/fees/tuition.blade.php ENDPATH**/ ?>