<?php
  $customizerHidden = 'customizer-hide';
?>



<?php $__env->startSection('title', 'Transfer Page'); ?>

<?php $__env->startSection('vendor-style'); ?>
  <!-- Vendor -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/styles/index.min.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
  <!-- Page -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-auth.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/bundle/popular.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/plugin-bootstrap5/index.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/vendor/libs/@form-validation/umd/plugin-auto-focus/index.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
  <script src="<?php echo e(asset('assets/js/pages-auth.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
  <div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
      <div class="authentication-inner py-4">

        <!-- Register -->
        <div class="card">
          <div class="card-body">
            <!-- Logo -->
            <div class="app-brand justify-content-center">
              <a href="<?php echo e(url('/admin/auth/login')); ?>" class="app-brand-link gap-2">
                <span class="app-brand-logo demo"><?php echo $__env->make('_partials.macros', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></span>
                <span class="app-brand-text demo h3 mb-0 fw-bold">Data Transfer Page</span>
              </a>
            </div>
            <!-- /Logo -->

            <p class="mb-4" style="text-align: justify">Please confirm the detail below. if correct click the button to migrate your data to the new portal. Ensure you email you are filling in is active, a password reset link will be sent to it</p>
            <?php if(session()->has('errors')): ?>
              <div class="alert alert-danger alert-dismissible d-flex align-items-center" role="alert">
                <?php echo e(session('errors')->first()); ?>


                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            <?php endif; ?>
            <?php if(session()->has('error')): ?>
              <div class="alert alert-warning alert-dismissible d-flex align-items-center" role="alert">
                <?php echo e(session()->get('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                </button>
              </div>
            <?php endif; ?>
            <form id="formAuthentication" class="mb-3" action="<?php echo e(route('post.data.for.transfer')); ?>" method="post">
              <?php echo csrf_field(); ?>
              <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" id="email" name="email"
                       value="<?php echo e($email); ?>" autofocus>
              </div>

              <div class="mb-3">
                <label for="regnumber" class="form-label">Registration Number</label>
                <input type="text" class="form-control" id="regno" name="regno" value="<?php echo e($regnumb); ?>" autofocus>
              </div>


              <button class="btn btn-primary d-grid w-100">
                Verify and transfer
              </button>
            </form>



          </div>
        </div>
        <!-- /Register -->
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/content/authentications/transferpage.blade.php ENDPATH**/ ?>