<?php
  $configData = Helper::appClasses();
  $customizerHidden = 'customizer-hide';
?>



<?php $__env->startSection('title', 'Verify Email'); ?>

<?php $__env->startSection('page-style'); ?>
  <!-- Page -->
  <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-auth.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
  <div class="authentication-wrapper authentication-cover">
    <div class="authentication-inner row m-0">

      <!-- /Left Text -->
      <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center">
        <div class="flex-row text-center mx-auto">
          <img src="<?php echo e(asset('assets/img/pages/login-'.$configData['style'].'.png')); ?>" alt="Auth Cover Bg color" width="520" class="img-fluid authentication-cover-img" data-app-light-img="pages/login-light.png" data-app-dark-img="pages/login-dark.png">
          <div class="mx-auto">
            <h3>Nwafor Orizu College Of Education</h3>
            <p>
              Excellence in knowledge, virtue and service.
            </p>
          </div>
        </div>
      </div>
      <!-- /Left Text -->

      <!--  Verify email -->
      <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-4 p-sm-5">
        <div class="w-px-400 mx-auto">
          <div class="app-brand mb-4">
            <a href="<?php echo e(url('/')); ?>" class="app-brand-link gap-2 mb-2">
              <span class="app-brand-logo demo"><?php echo $__env->make('_partials.macros', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?></span>
              <span class="app-brand-text demo h3 mb-0 fw-bold"><?php echo e(config('variables.templateName')); ?></span>
            </a>
          </div>
          <h4 class="mb-2">Verify your email ✉️</h4>
          <p class="text-start">
            Email Verification link has been sent to your email address. Please follow the link inside to continue.
          </p>

          <p class="text-center">Didn't get the mail? </p>
          <?php if(session()->has('status')): ?>
            <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
              <?php echo e(session('status')); ?>


              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          <?php endif; ?>
          <form class="form-auth-small" method="post" action="<?php echo e(route('verification.send')); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-primary w-100 my-3">Resend Verification Email</button>

          </form>

          <p class="text-center">---------- or ----------</p>
          <form class="form-auth-small" method="post" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-danger w-100 my-3">Logout</button>

          </form>

        </div>
      </div>
      <!-- / Verify email -->
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\portal\resources\views/content/authentications/verify-email.blade.php ENDPATH**/ ?>