@php
  $configData = Helper::appClasses();
  $customizerHidden = 'customizer-hide';
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Verify Email')

@section('page-style')
  <!-- Page -->
  <link rel="stylesheet" href="{{asset('assets/vendor/css/pages/page-auth.css')}}">
@endsection


@section('content')
  <div class="authentication-wrapper authentication-cover">
    <div class="authentication-inner row m-0">

      <!-- /Left Text -->
      <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center">
        <div class="flex-row text-center mx-auto">
          <img src="{{asset('assets/img/pages/login-'.$configData['style'].'.png')}}" alt="Auth Cover Bg color" width="520" class="img-fluid authentication-cover-img" data-app-light-img="pages/login-light.png" data-app-dark-img="pages/login-dark.png">
          <div class="mx-auto">
            <h3>Nwafor Orizu College Of Education</h3>
            <p>
              Excellence in knowledge, virtue and service.
            </p>
          </div>
        </div>
      </div>
      <!-- /Left Text -->

      <!--  Verify email -->
      <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-4 p-sm-5">
        <div class="w-px-400 mx-auto">
          <div class="app-brand mb-4">
            <a href="{{url('/')}}" class="app-brand-link gap-2 mb-2">
              <span class="app-brand-logo demo">@include('_partials.macros')</span>
              <span class="app-brand-text demo h3 mb-0 fw-bold">{{ config('variables.templateName') }}</span>
            </a>
          </div>
          <h4 class="mb-2">Verify your email ✉️</h4>
          <p class="text-start">
            Email Verification link has been sent to your email address. Please follow the link inside to continue.
          </p>

          <p class="text-center">Didn't get the mail? </p>
          @if(session()->has('status'))
            <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
              {{session('status')}}

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              </button>
            </div>
          @endif
          <form class="form-auth-small" method="post" action="{{ route('verification.send') }}">
            @csrf
            <button type="submit" class="btn btn-primary w-100 my-3">Resend Verification Email</button>

          </form>

          <p class="text-center">---------- or ----------</p>
          <form class="form-auth-small" method="post" action="{{ route('logout') }}">
            @csrf
            <button type="submit" class="btn btn-danger w-100 my-3">Logout</button>

          </form>

        </div>
      </div>
      <!-- / Verify email -->
    </div>
  </div>
@endsection
