<?php

namespace App\Http\Controllers;

use App\Models\Fee;
use App\Models\Payment;
use App\Models\Payment_rrr;
use App\Http\Requests\StorePayment_rrrRequest;
use App\Http\Requests\UpdatePayment_rrrRequest;

class PaymentRrrController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($payid)
    {
        $payment=Payment::find($payid);

        $rrr=Payment_rrr::where('payment_id',$payid)->get();
      $hash_string = config('remita.MERCHANTID') . $payment->id . $payment->amount_paid . config('remita.APIKEY');
      $hash = hash('sha512', $hash_string);
        return view('fees.payment_rrr',compact('payment','rrr','hash'));

    }

    public function verifyRrr( $rrr){
      try {
        $result = Payment::VerifyPaymentRrr($rrr);
        $rrr=Payment_rrr::where('rrr',$rrr)->first();
         $payment=Payment::find($rrr->payment_id);
        if($result['status']=='023'){
          $msg="Invalid RRR";

          return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
        }elseif($result['status']=='01'){
         if($payment->outstanding >0){
            $rrr->status = "1";
            $rrr->payment_date = $result['paymentDate'];
            $rrr->transaction_time = $result['transactiontime'];
            $rrr->message = $result['message'];
            $rrr->save();
            $payment->status = "Partly Paid";
            $payment->save();
          }else {
            $rrr->status = "1";
            $rrr->payment_date = $result['paymentDate'];
            $rrr->transaction_time = $result['transactiontime'];
            $rrr->message = $result['message'];
            $rrr->save();
            $payment->status = "Paid";
            $payment->save();
          }
          $msg="Payment received";
          $hash_string = config('remita.MERCHANTID') . $payment->id . $payment->amount_paid . config('remita.APIKEY');
          $hash = hash('sha512', $hash_string);
          return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
        }elseif($result['status']=='021'){
          $msg="Not paid";
          $hash_string = config('remita.MERCHANTID') . $payment->id . $payment->amount_paid . config('remita.APIKEY');
          $hash = hash('sha512', $hash_string);
          return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
        }
      }catch (\Exception $e){

        $msg=$e->getMessage();
        return view('errors.402',compact('msg'));
      }
      $msg="Something went wrong, we are working on it.";
      return view('errors.402',compact('msg'));
    }

  public function verifyOrderId( $orderid){
    try {
      $result = Payment::VerifyPaymentOrderId($orderid);
      $rrr=Payment_rrr::where('order_id',$orderid)->first();
      $payment=Payment::find($rrr->payment_id);
      $fee=Fee::getFee(auth()->user()->department_id,$payment->student_level);
      $hash_string = config('remita.MERCHANTID') . $fee->service_type_id . $rrr->orderid . $rrr->amount . config('remita.APIKEY');
      $hash = hash('sha512', $hash_string);
      if($result['status']=='023'){
        $msg="Invalid Order Id";

        return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
      }elseif($result['status']=='01'){
        if($payment->outstanding >0){
          $rrr->status = "1";
          $rrr->payment_date = $result['paymentDate'];
          $rrr->transaction_time = $result['transactiontime'];
          $rrr->message = $result['message'];
          $rrr->save();
          $payment->status = "Partly Paid";
          $payment->save();
        }else {
          $rrr->status = "1";
          $rrr->payment_date = $result['paymentDate'];
          $rrr->transaction_time = $result['transactiontime'];
          $rrr->message = $result['message'];
          $rrr->save();
          $payment->status = "Paid";
          $payment->save();
        }
        $msg="Payment received";

        return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
      }elseif($result['status']=='021'){
        $msg="Not paid";

        return redirect()->route('listrrr',$rrr->payment_id)->withErrors(["msg"=>$msg]);
      }
    }catch (\Exception $e){

      $msg=$e->getMessage();
      return view('errors.402',compact('msg'));
    }
    $msg="Something went wrong, we are working on it.";
    return view('errors.402',compact('msg'));
  }


}
