<?php

namespace App\Http\Controllers\authentications;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules;

class LoginBasic extends Controller
{
  public function index()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.auth-login-basic', ['pageConfigs' => $pageConfigs]);
  }

  public function forgotPassword()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.auth-forgot-password', ['pageConfigs' => $pageConfigs]);
  }

  public function resetPassword(Request $request)
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('content.authentications.auth-reset-password', ['pageConfigs' => $pageConfigs, 'request' => $request]);
  }

  function studentLogin(LoginRequest $request): RedirectResponse
    {
    $request->authenticate();
    $request->session()->regenerate();

    return redirect()->intended(RouteServiceProvider::HOME);
    }
  function Studentloginold(Request $request)
  {

    $credentials = Validator::make($request->all(), [
      'email' => ['required', 'email'],
      'password' => ['required'],
    ]);
    if ($credentials->fails()) {
      Session::flash('error', $credentials->messages()->first());
      return redirect()->back()->withInput();
    }
    if (Auth::attempt(['reg_number' => $request->email, 'password' => $request->password,])) {
      $request->session()->regenerate();

        return redirect()->intended('dashboard');

    } elseif (Auth::attempt(['email' => $request->email, 'password' => $request->password,])) {
      $request->session()->regenerate();

        return redirect()->intended('dashboard');

    } else {
      Session::flash('error', "The provided credentials do not match our records");
      return redirect()->back()->onlyInput('email');
    }

  }


  public function logoutportal(Request $request): RedirectResponse
  {
    Auth::guard('web')->logout();

    $request->session()->invalidate();

    $request->session()->regenerateToken();

    return redirect()->route('auth-login-basic');
  }

  /**
   * Handle an incoming password reset link request.
   *
   * @throws \Illuminate\Validation\ValidationException
   */
  public function passwordResetLink(Request $request): RedirectResponse
  {
    $request->validate([
      'email' => ['required', 'email'],
    ]);

    // We will send the password reset link to this user. Once we have attempted
    // to send the link, we will examine the response then see the message we
    // need to show to the user. Finally, we'll send out a proper response.
    $status = Password::sendResetLink(
      $request->only('email')
    );

    return $status == Password::RESET_LINK_SENT
      ? back()->with('status', __($status))
      : back()->withInput($request->only('email'))
        ->withErrors(['email' => __($status)]);
  }

  public function studentPasswordReset(Request $request): RedirectResponse
  {
    $request->validate([
      'token' => ['required'],
      'email' => ['required', 'email'],
      'password' => ['required', 'confirmed', Rules\Password::defaults()],
    ]);

    // Here we will attempt to reset the user's password. If it is successful we
    // will update the password on an actual user model and persist it to the
    // database. Otherwise we will parse the error and return the response.
    $status = Password::reset(
      $request->only('email', 'password', 'password_confirmation', 'token'),
      function ($user) use ($request) {
        $user->forceFill([
          'password' => Hash::make($request->password),
          'remember_token' => Str::random(60),
        ])->save();

        event(new PasswordReset($user));
      }
    );

    // If the password was successfully reset, we will redirect the user back to
    // the application's home authenticated view. If there is an error we can
    // redirect them back to where they came from with their error message.
    return $status == Password::PASSWORD_RESET
      ? redirect()->route('auth-login-basic')->with('status', __($status))
      : back()->withInput($request->only('email'))
        ->withErrors(['email' => __($status)]);
  }
  function updatepasswordportal(Request $request){
    $validator = Validator::make($request->all(), [
      'oldpassword' => ['required'],
      'password'=>'required|confirmed'
    ]);
    if ($validator->fails()) {
      Session::flash('error', $validator->messages()->first());
      return redirect()->back()->withInput();
    }
    if (Hash::check($request->oldpassword, $request->user()->password)) {
      User::where('email',$request->user()->email)->update(["password"=>Hash::make($request->password)]);
      Session::flash('error', "Password Changed Successfully");
      return redirect()->route('dashboard');
    }else{
      return back()->withErrors([
        'password' => ['The provided password does not match our records.']
      ]);
    }
  }



}
