<?php

namespace App\Http\Controllers;

use App\Models\CourseForm;
use App\Http\Requests\StoreCourseFormRequest;
use App\Http\Requests\UpdateCourseFormRequest;
use App\Models\Courses;
use App\Models\DepartmentCourseSettings;
use App\Models\Semester;

class CourseFormController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
      $semester = Semester::where('status', 1)->first();
      $user = auth()->user();
      $deptSettings=DepartmentCourseSettings::where(['department_id'=>$user->department_id,'level'=>$user->s_level,'semester'=>$semester->id])->first();
      $course = Courses::where(['department_id'=>$user->department_id,'level'=>$user->s_level,'semester'=>$semester->id])->get();
      return view('courses.load_course_form', compact('course','deptSettings','user','semester'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function listform()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCourseFormRequest $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(CourseForm $courseForm)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CourseForm $courseForm)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCourseFormRequest $request, CourseForm $courseForm)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CourseForm $courseForm)
    {
        //
    }
}
